% This is a function for generation Mackey-Glass Time Series
% MG Series is periodic for tau<17 otherwise non-periodic
% Eular's method is for solving MG diffrential equation
% ds(t)/dt = 0.2s(t-tau)/(1+s(t-tau)^10) - 0.1s(t)
%
% Usage: 
%    data = mgts(n,tau);
%
% Inputs: 
%    n    -   number of samples
%    tau  -   the tau constant in the equation           
%
% Output: 
%    data -   the time series vector (row)
%
% Example:
%    data = mgts(500,12);


function mydata = mgts(nm,tau);
for t = 1:nm+tau-1
    if t <= tau
        s(t) = 0.9;
    else
        s(t) = 0.9*s(t-1)+(0.2*s(t-tau))/(1+s(t-tau)^10);
    end
end
mydata = s(tau+1:end);