% MAKETimeSeriesTrainingPoints
% This is a function to make training samples for a neural network
% from a time series ( ts(t) ) with one output.
% The input of a training sample is some consecutive previous samples
% of the time series, the output is the following sample from the 
% time series.
% Training sample inputs:  X(k) = [ts(k-n),ts(k-n+1), ... ts(k-1)] 
% Training sample targets: Y(k) = ts(k)
%
% Usage:
%    [X,Y] = maketstp(ts,n);
%
% Inputs:
%    ts   -   the time series vector
%    n    -   the length of the training sample input (X(k))
%
% Outputs:
%    X    -   the training sample inputs (n*k matrix)
%    Y    -   the training sample targets (k row-vector)
%
% Example:
%    ts = [1:1000];
%    [tpx,tpy] = maketstp(ts,5);
%


function [x,y] = maketstp(ts,n);
x=[];
y=[];
for j=1:length(ts)-n
    for k=1:n
        x(j,k)=ts(j+k-1);        
    end

    y(j,1)=ts(j+n);


end
